function cat_view=identify_location(x,y)

%% Function to determine what the participant is looking at 

[x_dashboard, y_dashboard, x_road_centre, y_road_centre, x_road_left, y_road_left, x_road_right, y_road_right, x_air, y_air]=loadcoordinates();


%%

category_view = strings(length(x),1);
category_view(:) = 95; %else

for i=1:length(x)
    if x(i)==0 
       category_view(i) = 96; % NaN
    elseif isnan(x(i)) && isnan(y(i))
        category_view(i) = 97; % NaN
    elseif y(i)>1080 || x(i)>1920 || y(i)<0 || x(i)<0
        category_view(i)=99; % out of screen
    elseif x(i)>1492 && x(i)<1740 && y(i)>742 && y(i)<942
        category_view(i) = 5; % right mirror
    elseif inpolygon(x(i),y(i),x_dashboard,y_dashboard)==1
        category_view(i) = 6;  % dashboard
    elseif x(i)>34 && x(i)<429 && y(i)>741 && y(i)<939 
        category_view(i) = 1; % left mirror
    elseif x(i)>1025 && x(i)<1665 && y(i)>51 && y(i)<231
        category_view(i) = 7; % center mirror
    elseif inpolygon(x(i),y(i),x_road_centre,y_road_centre)==1
        category_view(i) = 3; % road center
    elseif inpolygon(x(i),y(i),x_road_left,y_road_left)==1
        category_view(i) = 2; % left road
    elseif inpolygon(x(i),y(i),x_road_right,y_road_right)==1
        category_view(i) = 4;    % right road
    elseif inpolygon(x(i),y(i),x_air,y_air)==1
        category_view(i) = 8; % air
    end
end

cat_view = category_view;